/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest;

public class ModifyDbClusterSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifyDbClusterSnapshotAttributeRequest>, ModifyDbClusterSnapshotAttributeRequest> {
    public Request<ModifyDbClusterSnapshotAttributeRequest> marshall(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) {
        if (modifyDbClusterSnapshotAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDbClusterSnapshotAttributeRequest, "RdsClient");
        request.addParameter("Action", "ModifyDBClusterSnapshotAttribute");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDbClusterSnapshotAttributeRequest.dbClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringConversion.fromString((String)modifyDbClusterSnapshotAttributeRequest.dbClusterSnapshotIdentifier()));
        }
        if (modifyDbClusterSnapshotAttributeRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringConversion.fromString((String)modifyDbClusterSnapshotAttributeRequest.attributeName()));
        }
        if (modifyDbClusterSnapshotAttributeRequest.valuesToAdd().isEmpty() && !(modifyDbClusterSnapshotAttributeRequest.valuesToAdd() instanceof SdkAutoConstructList)) {
            request.addParameter("ValuesToAdd", "");
        } else if (!modifyDbClusterSnapshotAttributeRequest.valuesToAdd().isEmpty() && !(modifyDbClusterSnapshotAttributeRequest.valuesToAdd() instanceof SdkAutoConstructList)) {
            List<String> valuesToAddList = modifyDbClusterSnapshotAttributeRequest.valuesToAdd();
            int valuesToAddListIndex = 1;
            for (String valuesToAddListValue : valuesToAddList) {
                if (valuesToAddListValue != null) {
                    request.addParameter("ValuesToAdd.AttributeValue." + valuesToAddListIndex, StringConversion.fromString((String)valuesToAddListValue));
                }
                ++valuesToAddListIndex;
            }
        }
        if (modifyDbClusterSnapshotAttributeRequest.valuesToRemove().isEmpty() && !(modifyDbClusterSnapshotAttributeRequest.valuesToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("ValuesToRemove", "");
        } else if (!modifyDbClusterSnapshotAttributeRequest.valuesToRemove().isEmpty() && !(modifyDbClusterSnapshotAttributeRequest.valuesToRemove() instanceof SdkAutoConstructList)) {
            List<String> valuesToRemoveList = modifyDbClusterSnapshotAttributeRequest.valuesToRemove();
            int valuesToRemoveListIndex = 1;
            for (String valuesToRemoveListValue : valuesToRemoveList) {
                if (valuesToRemoveListValue != null) {
                    request.addParameter("ValuesToRemove.AttributeValue." + valuesToRemoveListIndex, StringConversion.fromString((String)valuesToRemoveListValue));
                }
                ++valuesToRemoveListIndex;
            }
        }
        return request;
    }
}

