/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.EventSubscription;

public class EventSubscriptionUnmarshaller
implements Unmarshaller<EventSubscription, StaxUnmarshallerContext> {
    private static final EventSubscriptionUnmarshaller INSTANCE = new EventSubscriptionUnmarshaller();

    public EventSubscription unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventSubscription.Builder eventSubscription;
        block15: {
            eventSubscription = EventSubscription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<String> sourceIdsList = null;
            ArrayList<String> eventCategoriesList = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    eventSubscription.sourceIdsList(sourceIdsList);
                    eventSubscription.eventCategoriesList(eventCategoriesList);
                    break block15;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("CustomerAwsId", targetDepth)) {
                        eventSubscription.customerAwsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CustSubscriptionId", targetDepth)) {
                        eventSubscription.custSubscriptionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnsTopicArn", targetDepth)) {
                        eventSubscription.snsTopicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        eventSubscription.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SubscriptionCreationTime", targetDepth)) {
                        eventSubscription.subscriptionCreationTime(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceType", targetDepth)) {
                        eventSubscription.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceIdsList", targetDepth)) {
                        sourceIdsList = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SourceIdsList/SourceId", targetDepth)) {
                        sourceIdsList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EventCategoriesList", targetDepth)) {
                        eventCategoriesList = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("EventCategoriesList/EventCategory", targetDepth)) {
                        eventCategoriesList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Enabled", targetDepth)) {
                        eventSubscription.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EventSubscriptionArn", targetDepth)) continue;
                    eventSubscription.eventSubscriptionArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            eventSubscription.sourceIdsList(sourceIdsList);
            eventSubscription.eventCategoriesList(eventCategoriesList);
        }
        return (EventSubscription)eventSubscription.build();
    }

    public static EventSubscriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

