/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeEngineDefaultClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeEngineDefaultClusterParametersRequest>, DescribeEngineDefaultClusterParametersRequest> {
    public Request<DescribeEngineDefaultClusterParametersRequest> marshall(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        if (describeEngineDefaultClusterParametersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEngineDefaultClusterParametersRequest, "RdsClient");
        request.addParameter("Action", "DescribeEngineDefaultClusterParameters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEngineDefaultClusterParametersRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringConversion.fromString((String)describeEngineDefaultClusterParametersRequest.dbParameterGroupFamily()));
        }
        if (describeEngineDefaultClusterParametersRequest.filters().isEmpty() && !(describeEngineDefaultClusterParametersRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeEngineDefaultClusterParametersRequest.filters().isEmpty() && !(describeEngineDefaultClusterParametersRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeEngineDefaultClusterParametersRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeEngineDefaultClusterParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEngineDefaultClusterParametersRequest.maxRecords()));
        }
        if (describeEngineDefaultClusterParametersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeEngineDefaultClusterParametersRequest.marker()));
        }
        return request;
    }
}

