/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeDbClusterSnapshotsRequest>, DescribeDbClusterSnapshotsRequest> {
    public Request<DescribeDbClusterSnapshotsRequest> marshall(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        if (describeDbClusterSnapshotsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbClusterSnapshotsRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBClusterSnapshots");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbClusterSnapshotsRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)describeDbClusterSnapshotsRequest.dbClusterIdentifier()));
        }
        if (describeDbClusterSnapshotsRequest.dbClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringConversion.fromString((String)describeDbClusterSnapshotsRequest.dbClusterSnapshotIdentifier()));
        }
        if (describeDbClusterSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringConversion.fromString((String)describeDbClusterSnapshotsRequest.snapshotType()));
        }
        if (describeDbClusterSnapshotsRequest.filters().isEmpty() && !(describeDbClusterSnapshotsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbClusterSnapshotsRequest.filters().isEmpty() && !(describeDbClusterSnapshotsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbClusterSnapshotsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbClusterSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbClusterSnapshotsRequest.maxRecords()));
        }
        if (describeDbClusterSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbClusterSnapshotsRequest.marker()));
        }
        if (describeDbClusterSnapshotsRequest.includeShared() != null) {
            request.addParameter("IncludeShared", StringConversion.fromBoolean((Boolean)describeDbClusterSnapshotsRequest.includeShared()));
        }
        if (describeDbClusterSnapshotsRequest.includePublic() != null) {
            request.addParameter("IncludePublic", StringConversion.fromBoolean((Boolean)describeDbClusterSnapshotsRequest.includePublic()));
        }
        return request;
    }
}

