/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbClusterBacktracksRequestMarshaller
implements Marshaller<Request<DescribeDbClusterBacktracksRequest>, DescribeDbClusterBacktracksRequest> {
    public Request<DescribeDbClusterBacktracksRequest> marshall(DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) {
        if (describeDbClusterBacktracksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbClusterBacktracksRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBClusterBacktracks");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbClusterBacktracksRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)describeDbClusterBacktracksRequest.dbClusterIdentifier()));
        }
        if (describeDbClusterBacktracksRequest.backtrackIdentifier() != null) {
            request.addParameter("BacktrackIdentifier", StringConversion.fromString((String)describeDbClusterBacktracksRequest.backtrackIdentifier()));
        }
        if (describeDbClusterBacktracksRequest.filters().isEmpty() && !(describeDbClusterBacktracksRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbClusterBacktracksRequest.filters().isEmpty() && !(describeDbClusterBacktracksRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbClusterBacktracksRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbClusterBacktracksRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbClusterBacktracksRequest.maxRecords()));
        }
        if (describeDbClusterBacktracksRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbClusterBacktracksRequest.marker()));
        }
        return request;
    }
}

