/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbParameterGroupRequestMarshaller
implements Marshaller<Request<CreateDbParameterGroupRequest>, CreateDbParameterGroupRequest> {
    public Request<CreateDbParameterGroupRequest> marshall(CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        if (createDbParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbParameterGroupRequest, "RdsClient");
        request.addParameter("Action", "CreateDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbParameterGroupRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringConversion.fromString((String)createDbParameterGroupRequest.dbParameterGroupName()));
        }
        if (createDbParameterGroupRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringConversion.fromString((String)createDbParameterGroupRequest.dbParameterGroupFamily()));
        }
        if (createDbParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createDbParameterGroupRequest.description()));
        }
        if (createDbParameterGroupRequest.tags().isEmpty() && !(createDbParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbParameterGroupRequest.tags().isEmpty() && !(createDbParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbParameterGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

