/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CreateDbClusterParameterGroupRequest>, CreateDbClusterParameterGroupRequest> {
    public Request<CreateDbClusterParameterGroupRequest> marshall(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        if (createDbClusterParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbClusterParameterGroupRequest, "RdsClient");
        request.addParameter("Action", "CreateDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbClusterParameterGroupRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringConversion.fromString((String)createDbClusterParameterGroupRequest.dbClusterParameterGroupName()));
        }
        if (createDbClusterParameterGroupRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringConversion.fromString((String)createDbClusterParameterGroupRequest.dbParameterGroupFamily()));
        }
        if (createDbClusterParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createDbClusterParameterGroupRequest.description()));
        }
        if (createDbClusterParameterGroupRequest.tags().isEmpty() && !(createDbClusterParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbClusterParameterGroupRequest.tags().isEmpty() && !(createDbClusterParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbClusterParameterGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

