/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CopyDbSnapshotRequestMarshaller
implements Marshaller<Request<CopyDbSnapshotRequest>, CopyDbSnapshotRequest> {
    public Request<CopyDbSnapshotRequest> marshall(CopyDbSnapshotRequest copyDbSnapshotRequest) {
        if (copyDbSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyDbSnapshotRequest, "RdsClient");
        request.addParameter("Action", "CopyDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDbSnapshotRequest.sourceDBSnapshotIdentifier() != null) {
            request.addParameter("SourceDBSnapshotIdentifier", StringConversion.fromString((String)copyDbSnapshotRequest.sourceDBSnapshotIdentifier()));
        }
        if (copyDbSnapshotRequest.targetDBSnapshotIdentifier() != null) {
            request.addParameter("TargetDBSnapshotIdentifier", StringConversion.fromString((String)copyDbSnapshotRequest.targetDBSnapshotIdentifier()));
        }
        if (copyDbSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)copyDbSnapshotRequest.kmsKeyId()));
        }
        if (copyDbSnapshotRequest.tags().isEmpty() && !(copyDbSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!copyDbSnapshotRequest.tags().isEmpty() && !(copyDbSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = copyDbSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (copyDbSnapshotRequest.copyTags() != null) {
            request.addParameter("CopyTags", StringConversion.fromBoolean((Boolean)copyDbSnapshotRequest.copyTags()));
        }
        if (copyDbSnapshotRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringConversion.fromString((String)copyDbSnapshotRequest.preSignedUrl()));
        }
        if (copyDbSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)copyDbSnapshotRequest.optionGroupName()));
        }
        if (copyDbSnapshotRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringConversion.fromString((String)copyDbSnapshotRequest.sourceRegion()));
        }
        return request;
    }
}

