/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CopyDbParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDbParameterGroupRequest>, CopyDbParameterGroupRequest> {
    public Request<CopyDbParameterGroupRequest> marshall(CopyDbParameterGroupRequest copyDbParameterGroupRequest) {
        if (copyDbParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyDbParameterGroupRequest, "RdsClient");
        request.addParameter("Action", "CopyDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDbParameterGroupRequest.sourceDBParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBParameterGroupIdentifier", StringConversion.fromString((String)copyDbParameterGroupRequest.sourceDBParameterGroupIdentifier()));
        }
        if (copyDbParameterGroupRequest.targetDBParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBParameterGroupIdentifier", StringConversion.fromString((String)copyDbParameterGroupRequest.targetDBParameterGroupIdentifier()));
        }
        if (copyDbParameterGroupRequest.targetDBParameterGroupDescription() != null) {
            request.addParameter("TargetDBParameterGroupDescription", StringConversion.fromString((String)copyDbParameterGroupRequest.targetDBParameterGroupDescription()));
        }
        if (copyDbParameterGroupRequest.tags().isEmpty() && !(copyDbParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!copyDbParameterGroupRequest.tags().isEmpty() && !(copyDbParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = copyDbParameterGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

