/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CopyDbClusterSnapshotRequestMarshaller
implements Marshaller<Request<CopyDbClusterSnapshotRequest>, CopyDbClusterSnapshotRequest> {
    public Request<CopyDbClusterSnapshotRequest> marshall(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        if (copyDbClusterSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyDbClusterSnapshotRequest, "RdsClient");
        request.addParameter("Action", "CopyDBClusterSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDbClusterSnapshotRequest.sourceDBClusterSnapshotIdentifier() != null) {
            request.addParameter("SourceDBClusterSnapshotIdentifier", StringConversion.fromString((String)copyDbClusterSnapshotRequest.sourceDBClusterSnapshotIdentifier()));
        }
        if (copyDbClusterSnapshotRequest.targetDBClusterSnapshotIdentifier() != null) {
            request.addParameter("TargetDBClusterSnapshotIdentifier", StringConversion.fromString((String)copyDbClusterSnapshotRequest.targetDBClusterSnapshotIdentifier()));
        }
        if (copyDbClusterSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)copyDbClusterSnapshotRequest.kmsKeyId()));
        }
        if (copyDbClusterSnapshotRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringConversion.fromString((String)copyDbClusterSnapshotRequest.preSignedUrl()));
        }
        if (copyDbClusterSnapshotRequest.copyTags() != null) {
            request.addParameter("CopyTags", StringConversion.fromBoolean((Boolean)copyDbClusterSnapshotRequest.copyTags()));
        }
        if (copyDbClusterSnapshotRequest.tags().isEmpty() && !(copyDbClusterSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!copyDbClusterSnapshotRequest.tags().isEmpty() && !(copyDbClusterSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = copyDbClusterSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

