/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeTarget
implements ToCopyableBuilder<Builder, UpgradeTarget> {
    private final String engine;
    private final String engineVersion;
    private final String description;
    private final Boolean autoUpgrade;
    private final Boolean isMajorVersionUpgrade;

    private UpgradeTarget(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.description = builder.description;
        this.autoUpgrade = builder.autoUpgrade;
        this.isMajorVersionUpgrade = builder.isMajorVersionUpgrade;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String description() {
        return this.description;
    }

    public Boolean autoUpgrade() {
        return this.autoUpgrade;
    }

    public Boolean isMajorVersionUpgrade() {
        return this.isMajorVersionUpgrade;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMajorVersionUpgrade());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeTarget)) {
            return false;
        }
        UpgradeTarget other = (UpgradeTarget)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.autoUpgrade(), other.autoUpgrade()) && Objects.equals(this.isMajorVersionUpgrade(), other.isMajorVersionUpgrade());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeTarget").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Description", (Object)this.description()).add("AutoUpgrade", (Object)this.autoUpgrade()).add("IsMajorVersionUpgrade", (Object)this.isMajorVersionUpgrade()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AutoUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoUpgrade()));
            }
            case "IsMajorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.isMajorVersionUpgrade()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String description;
        private Boolean autoUpgrade;
        private Boolean isMajorVersionUpgrade;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeTarget model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.description(model.description);
            this.autoUpgrade(model.autoUpgrade);
            this.isMajorVersionUpgrade(model.isMajorVersionUpgrade);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getAutoUpgrade() {
            return this.autoUpgrade;
        }

        @Override
        public final Builder autoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
            return this;
        }

        public final void setAutoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
        }

        public final Boolean getIsMajorVersionUpgrade() {
            return this.isMajorVersionUpgrade;
        }

        @Override
        public final Builder isMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
            return this;
        }

        public final void setIsMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
        }

        public UpgradeTarget build() {
            return new UpgradeTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpgradeTarget> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder description(String var1);

        public Builder autoUpgrade(Boolean var1);

        public Builder isMajorVersionUpgrade(Boolean var1);
    }
}

