/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingConfiguration
implements ToCopyableBuilder<Builder, ScalingConfiguration> {
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final Boolean autoPause;
    private final Integer secondsUntilAutoPause;

    private ScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public Integer maxCapacity() {
        return this.maxCapacity;
    }

    public Boolean autoPause() {
        return this.autoPause;
    }

    public Integer secondsUntilAutoPause() {
        return this.secondsUntilAutoPause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsUntilAutoPause());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfiguration)) {
            return false;
        }
        ScalingConfiguration other = (ScalingConfiguration)obj;
        return Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.autoPause(), other.autoPause()) && Objects.equals(this.secondsUntilAutoPause(), other.secondsUntilAutoPause());
    }

    public String toString() {
        return ToString.builder((String)"ScalingConfiguration").add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("AutoPause", (Object)this.autoPause()).add("SecondsUntilAutoPause", (Object)this.secondsUntilAutoPause()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "AutoPause": {
                return Optional.ofNullable(clazz.cast(this.autoPause()));
            }
            case "SecondsUntilAutoPause": {
                return Optional.ofNullable(clazz.cast(this.secondsUntilAutoPause()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minCapacity;
        private Integer maxCapacity;
        private Boolean autoPause;
        private Integer secondsUntilAutoPause;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfiguration model) {
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.autoPause(model.autoPause);
            this.secondsUntilAutoPause(model.secondsUntilAutoPause);
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Boolean getAutoPause() {
            return this.autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        public final Integer getSecondsUntilAutoPause() {
            return this.secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        public ScalingConfiguration build() {
            return new ScalingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingConfiguration> {
        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder autoPause(Boolean var1);

        public Builder secondsUntilAutoPause(Integer var1);
    }
}

