/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbClusterFromSnapshotRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
    private final List<String> availabilityZones;
    private final String dbClusterIdentifier;
    private final String snapshotIdentifier;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String dbSubnetGroupName;
    private final String databaseName;
    private final String optionGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Long backtrackWindow;
    private final List<String> enableCloudwatchLogsExports;
    private final String engineMode;
    private final ScalingConfiguration scalingConfiguration;

    private RestoreDbClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.databaseName = builder.databaseName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.engineMode = builder.engineMode;
        this.scalingConfiguration = builder.scalingConfiguration;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer port() {
        return this.port;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public String engineMode() {
        return this.engineMode;
    }

    public ScalingConfiguration scalingConfiguration() {
        return this.scalingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCloudwatchLogsExports());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDbClusterFromSnapshotRequest other = (RestoreDbClusterFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && Objects.equals(this.engineMode(), other.engineMode()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"RestoreDbClusterFromSnapshotRequest").add("AvailabilityZones", this.availabilityZones()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Port", (Object)this.port()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DatabaseName", (Object)this.databaseName()).add("OptionGroupName", (Object)this.optionGroupName()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("Tags", this.tags()).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("EnableCloudwatchLogsExports", this.enableCloudwatchLogsExports()).add("EngineMode", (Object)this.engineMode()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterIdentifier;
        private String snapshotIdentifier;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String dbSubnetGroupName;
        private String databaseName;
        private String optionGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;
        private Long backtrackWindow;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private String engineMode;
        private ScalingConfiguration scalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromSnapshotRequest model) {
            super(model);
            this.availabilityZones(model.availabilityZones);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.port(model.port);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.databaseName(model.databaseName);
            this.optionGroupName(model.optionGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.backtrackWindow(model.backtrackWindow);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.engineMode(model.engineMode);
            this.scalingConfiguration(model.scalingConfiguration);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromSnapshotRequest build() {
            return new RestoreDbClusterFromSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder databaseName(String var1);

        public Builder optionGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder backtrackWindow(Long var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder engineMode(String var1);

        public Builder scalingConfiguration(ScalingConfiguration var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfiguration)((ScalingConfiguration.Builder)ScalingConfiguration.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

