/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingCloudwatchLogsExports
implements ToCopyableBuilder<Builder, PendingCloudwatchLogsExports> {
    private final List<String> logTypesToEnable;
    private final List<String> logTypesToDisable;

    private PendingCloudwatchLogsExports(BuilderImpl builder) {
        this.logTypesToEnable = builder.logTypesToEnable;
        this.logTypesToDisable = builder.logTypesToDisable;
    }

    public List<String> logTypesToEnable() {
        return this.logTypesToEnable;
    }

    public List<String> logTypesToDisable() {
        return this.logTypesToDisable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypesToEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypesToDisable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingCloudwatchLogsExports)) {
            return false;
        }
        PendingCloudwatchLogsExports other = (PendingCloudwatchLogsExports)obj;
        return Objects.equals(this.logTypesToEnable(), other.logTypesToEnable()) && Objects.equals(this.logTypesToDisable(), other.logTypesToDisable());
    }

    public String toString() {
        return ToString.builder((String)"PendingCloudwatchLogsExports").add("LogTypesToEnable", this.logTypesToEnable()).add("LogTypesToDisable", this.logTypesToDisable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogTypesToEnable": {
                return Optional.ofNullable(clazz.cast(this.logTypesToEnable()));
            }
            case "LogTypesToDisable": {
                return Optional.ofNullable(clazz.cast(this.logTypesToDisable()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> logTypesToEnable = DefaultSdkAutoConstructList.getInstance();
        private List<String> logTypesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PendingCloudwatchLogsExports model) {
            this.logTypesToEnable(model.logTypesToEnable);
            this.logTypesToDisable(model.logTypesToDisable);
        }

        public final Collection<String> getLogTypesToEnable() {
            return this.logTypesToEnable;
        }

        @Override
        public final Builder logTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToEnable(String ... logTypesToEnable) {
            this.logTypesToEnable(Arrays.asList(logTypesToEnable));
            return this;
        }

        public final void setLogTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = LogTypeListCopier.copy(logTypesToEnable);
        }

        public final Collection<String> getLogTypesToDisable() {
            return this.logTypesToDisable;
        }

        @Override
        public final Builder logTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToDisable(String ... logTypesToDisable) {
            this.logTypesToDisable(Arrays.asList(logTypesToDisable));
            return this;
        }

        public final void setLogTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = LogTypeListCopier.copy(logTypesToDisable);
        }

        public PendingCloudwatchLogsExports build() {
            return new PendingCloudwatchLogsExports(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingCloudwatchLogsExports> {
        public Builder logTypesToEnable(Collection<String> var1);

        public Builder logTypesToEnable(String ... var1);

        public Builder logTypesToDisable(Collection<String> var1);

        public Builder logTypesToDisable(String ... var1);
    }
}

