/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyEventSubscriptionRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyEventSubscriptionRequest> {
    private final String subscriptionName;
    private final String snsTopicArn;
    private final String sourceType;
    private final List<String> eventCategories;
    private final Boolean enabled;

    private ModifyEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
        this.enabled = builder.enabled;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEventSubscriptionRequest)) {
            return false;
        }
        ModifyEventSubscriptionRequest other = (ModifyEventSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"ModifyEventSubscriptionRequest").add("SubscriptionName", (Object)this.subscriptionName()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SourceType", (Object)this.sourceType()).add("EventCategories", this.eventCategories()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String subscriptionName;
        private String snsTopicArn;
        private String sourceType;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEventSubscriptionRequest model) {
            super(model);
            this.subscriptionName(model.subscriptionName);
            this.snsTopicArn(model.snsTopicArn);
            this.sourceType(model.sourceType);
            this.eventCategories(model.eventCategories);
            this.enabled(model.enabled);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEventSubscriptionRequest build() {
            return new ModifyEventSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, ModifyEventSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder snsTopicArn(String var1);

        public Builder sourceType(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

