/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterSnapshot
implements ToCopyableBuilder<Builder, DBClusterSnapshot> {
    private final List<String> availabilityZones;
    private final String dbClusterSnapshotIdentifier;
    private final String dbClusterIdentifier;
    private final Instant snapshotCreateTime;
    private final String engine;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String vpcId;
    private final Instant clusterCreateTime;
    private final String masterUsername;
    private final String engineVersion;
    private final String licenseModel;
    private final String snapshotType;
    private final Integer percentProgress;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterSnapshotArn;
    private final String sourceDBClusterSnapshotArn;
    private final Boolean iamDatabaseAuthenticationEnabled;

    private DBClusterSnapshot(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.percentProgress = builder.percentProgress;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterSnapshotArn = builder.dbClusterSnapshotArn;
        this.sourceDBClusterSnapshotArn = builder.sourceDBClusterSnapshotArn;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public String engine() {
        return this.engine;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public Integer percentProgress() {
        return this.percentProgress;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbClusterSnapshotArn() {
        return this.dbClusterSnapshotArn;
    }

    public String sourceDBClusterSnapshotArn() {
        return this.sourceDBClusterSnapshotArn;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterSnapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshot)) {
            return false;
        }
        DBClusterSnapshot other = (DBClusterSnapshot)obj;
        return Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbClusterSnapshotArn(), other.dbClusterSnapshotArn()) && Objects.equals(this.sourceDBClusterSnapshotArn(), other.sourceDBClusterSnapshotArn()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled());
    }

    public String toString() {
        return ToString.builder((String)"DBClusterSnapshot").add("AvailabilityZones", this.availabilityZones()).add("DBClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("Engine", (Object)this.engine()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("Status", (Object)this.status()).add("Port", (Object)this.port()).add("VpcId", (Object)this.vpcId()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("MasterUsername", (Object)this.masterUsername()).add("EngineVersion", (Object)this.engineVersion()).add("LicenseModel", (Object)this.licenseModel()).add("SnapshotType", (Object)this.snapshotType()).add("PercentProgress", (Object)this.percentProgress()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DBClusterSnapshotArn", (Object)this.dbClusterSnapshotArn()).add("SourceDBClusterSnapshotArn", (Object)this.sourceDBClusterSnapshotArn()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "DBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "SnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DBClusterSnapshotArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotArn()));
            }
            case "SourceDBClusterSnapshotArn": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterSnapshotArn()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterSnapshotIdentifier;
        private String dbClusterIdentifier;
        private Instant snapshotCreateTime;
        private String engine;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String vpcId;
        private Instant clusterCreateTime;
        private String masterUsername;
        private String engineVersion;
        private String licenseModel;
        private String snapshotType;
        private Integer percentProgress;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterSnapshotArn;
        private String sourceDBClusterSnapshotArn;
        private Boolean iamDatabaseAuthenticationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshot model) {
            this.availabilityZones(model.availabilityZones);
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.engine(model.engine);
            this.allocatedStorage(model.allocatedStorage);
            this.status(model.status);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.clusterCreateTime(model.clusterCreateTime);
            this.masterUsername(model.masterUsername);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.snapshotType(model.snapshotType);
            this.percentProgress(model.percentProgress);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbClusterSnapshotArn(model.dbClusterSnapshotArn);
            this.sourceDBClusterSnapshotArn(model.sourceDBClusterSnapshotArn);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDBClusterSnapshotArn() {
            return this.dbClusterSnapshotArn;
        }

        @Override
        public final Builder dbClusterSnapshotArn(String dbClusterSnapshotArn) {
            this.dbClusterSnapshotArn = dbClusterSnapshotArn;
            return this;
        }

        public final void setDBClusterSnapshotArn(String dbClusterSnapshotArn) {
            this.dbClusterSnapshotArn = dbClusterSnapshotArn;
        }

        public final String getSourceDBClusterSnapshotArn() {
            return this.sourceDBClusterSnapshotArn;
        }

        @Override
        public final Builder sourceDBClusterSnapshotArn(String sourceDBClusterSnapshotArn) {
            this.sourceDBClusterSnapshotArn = sourceDBClusterSnapshotArn;
            return this;
        }

        public final void setSourceDBClusterSnapshotArn(String sourceDBClusterSnapshotArn) {
            this.sourceDBClusterSnapshotArn = sourceDBClusterSnapshotArn;
        }

        public final Boolean getIAMDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIAMDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public DBClusterSnapshot build() {
            return new DBClusterSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBClusterSnapshot> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder engine(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder snapshotType(String var1);

        public Builder percentProgress(Integer var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterSnapshotArn(String var1);

        public Builder sourceDBClusterSnapshotArn(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);
    }
}

