/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyPendingMaintenanceActionRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ApplyPendingMaintenanceActionRequest> {
    private final String resourceIdentifier;
    private final String applyAction;
    private final String optInType;

    private ApplyPendingMaintenanceActionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.applyAction = builder.applyAction;
        this.optInType = builder.optInType;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public String applyAction() {
        return this.applyAction;
    }

    public String optInType() {
        return this.optInType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyPendingMaintenanceActionRequest)) {
            return false;
        }
        ApplyPendingMaintenanceActionRequest other = (ApplyPendingMaintenanceActionRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.applyAction(), other.applyAction()) && Objects.equals(this.optInType(), other.optInType());
    }

    public String toString() {
        return ToString.builder((String)"ApplyPendingMaintenanceActionRequest").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ApplyAction", (Object)this.applyAction()).add("OptInType", (Object)this.optInType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ApplyAction": {
                return Optional.ofNullable(clazz.cast(this.applyAction()));
            }
            case "OptInType": {
                return Optional.ofNullable(clazz.cast(this.optInType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String applyAction;
        private String optInType;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyPendingMaintenanceActionRequest model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.applyAction(model.applyAction);
            this.optInType(model.optInType);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final String getApplyAction() {
            return this.applyAction;
        }

        @Override
        public final Builder applyAction(String applyAction) {
            this.applyAction = applyAction;
            return this;
        }

        public final void setApplyAction(String applyAction) {
            this.applyAction = applyAction;
        }

        public final String getOptInType() {
            return this.optInType;
        }

        @Override
        public final Builder optInType(String optInType) {
            this.optInType = optInType;
            return this;
        }

        public final void setOptInType(String optInType) {
            this.optInType = optInType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyPendingMaintenanceActionRequest build() {
            return new ApplyPendingMaintenanceActionRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, ApplyPendingMaintenanceActionRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder applyAction(String var1);

        public Builder optInType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

