/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DoubleRange;
import software.amazon.awssdk.services.rds.model.Range;
import software.amazon.awssdk.services.rds.model.ValidStorageOptions;
import software.amazon.awssdk.services.rds.transform.DoubleRangeUnmarshaller;
import software.amazon.awssdk.services.rds.transform.RangeUnmarshaller;

public class ValidStorageOptionsUnmarshaller
implements Unmarshaller<ValidStorageOptions, StaxUnmarshallerContext> {
    private static final ValidStorageOptionsUnmarshaller INSTANCE = new ValidStorageOptionsUnmarshaller();

    public ValidStorageOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        ValidStorageOptions.Builder validStorageOptions;
        block10: {
            validStorageOptions = ValidStorageOptions.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Range> storageSize = null;
            ArrayList<Range> provisionedIops = null;
            ArrayList<DoubleRange> iopsToStorageRatio = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    validStorageOptions.storageSize(storageSize);
                    validStorageOptions.provisionedIops(provisionedIops);
                    validStorageOptions.iopsToStorageRatio(iopsToStorageRatio);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("StorageType", targetDepth)) {
                        validStorageOptions.storageType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StorageSize", targetDepth)) {
                        storageSize = new ArrayList<Range>();
                        continue;
                    }
                    if (context.testExpression("StorageSize/Range", targetDepth)) {
                        storageSize.add(RangeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ProvisionedIops", targetDepth)) {
                        provisionedIops = new ArrayList<Range>();
                        continue;
                    }
                    if (context.testExpression("ProvisionedIops/Range", targetDepth)) {
                        provisionedIops.add(RangeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IopsToStorageRatio", targetDepth)) {
                        iopsToStorageRatio = new ArrayList<DoubleRange>();
                        continue;
                    }
                    if (!context.testExpression("IopsToStorageRatio/DoubleRange", targetDepth)) continue;
                    iopsToStorageRatio.add(DoubleRangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            validStorageOptions.storageSize(storageSize);
            validStorageOptions.provisionedIops(provisionedIops);
            validStorageOptions.iopsToStorageRatio(iopsToStorageRatio);
        }
        return (ValidStorageOptions)validStorageOptions.build();
    }

    public static ValidStorageOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

