/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDbInstanceFromDbSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDbInstanceFromDbSnapshotRequest>, RestoreDbInstanceFromDbSnapshotRequest> {
    public Request<RestoreDbInstanceFromDbSnapshotRequest> marshall(RestoreDbInstanceFromDbSnapshotRequest restoreDbInstanceFromDbSnapshotRequest) {
        if (restoreDbInstanceFromDbSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDbInstanceFromDbSnapshotRequest, "RdsClient");
        request.addParameter("Action", "RestoreDBInstanceFromDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDbInstanceFromDbSnapshotRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.dbInstanceIdentifier()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.dbSnapshotIdentifier()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.dbInstanceClass()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreDbInstanceFromDbSnapshotRequest.port()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.availabilityZone()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.dbSubnetGroupName()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromDbSnapshotRequest.multiAZ()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromDbSnapshotRequest.publiclyAccessible()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromDbSnapshotRequest.autoMinorVersionUpgrade()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.licenseModel()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.dbName() != null) {
            request.addParameter("DBName", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.dbName()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.engine()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)restoreDbInstanceFromDbSnapshotRequest.iops()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.optionGroupName()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.tags().isEmpty() && !(restoreDbInstanceFromDbSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!restoreDbInstanceFromDbSnapshotRequest.tags().isEmpty() && !(restoreDbInstanceFromDbSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = restoreDbInstanceFromDbSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDbInstanceFromDbSnapshotRequest.storageType() != null) {
            request.addParameter("StorageType", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.storageType()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.tdeCredentialArn()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.tdeCredentialPassword()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.domain() != null) {
            request.addParameter("Domain", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.domain()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromDbSnapshotRequest.copyTagsToSnapshot()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringConversion.fromString((String)restoreDbInstanceFromDbSnapshotRequest.domainIAMRoleName()));
        }
        if (restoreDbInstanceFromDbSnapshotRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromDbSnapshotRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

