/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest;

public class RebootDbInstanceRequestMarshaller
implements Marshaller<Request<RebootDbInstanceRequest>, RebootDbInstanceRequest> {
    public Request<RebootDbInstanceRequest> marshall(RebootDbInstanceRequest rebootDbInstanceRequest) {
        if (rebootDbInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)rebootDbInstanceRequest, "RdsClient");
        request.addParameter("Action", "RebootDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootDbInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)rebootDbInstanceRequest.dbInstanceIdentifier()));
        }
        if (rebootDbInstanceRequest.forceFailover() != null) {
            request.addParameter("ForceFailover", StringConversion.fromBoolean((Boolean)rebootDbInstanceRequest.forceFailover()));
        }
        return request;
    }
}

