/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest;

public class ModifyDbSnapshotRequestMarshaller
implements Marshaller<Request<ModifyDbSnapshotRequest>, ModifyDbSnapshotRequest> {
    public Request<ModifyDbSnapshotRequest> marshall(ModifyDbSnapshotRequest modifyDbSnapshotRequest) {
        if (modifyDbSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDbSnapshotRequest, "RdsClient");
        request.addParameter("Action", "ModifyDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDbSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)modifyDbSnapshotRequest.dbSnapshotIdentifier()));
        }
        if (modifyDbSnapshotRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)modifyDbSnapshotRequest.engineVersion()));
        }
        if (modifyDbSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)modifyDbSnapshotRequest.optionGroupName()));
        }
        return request;
    }
}

