/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeReservedDbInstancesRequestMarshaller
implements Marshaller<Request<DescribeReservedDbInstancesRequest>, DescribeReservedDbInstancesRequest> {
    public Request<DescribeReservedDbInstancesRequest> marshall(DescribeReservedDbInstancesRequest describeReservedDbInstancesRequest) {
        if (describeReservedDbInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedDbInstancesRequest, "RdsClient");
        request.addParameter("Action", "DescribeReservedDBInstances");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedDbInstancesRequest.reservedDBInstanceId() != null) {
            request.addParameter("ReservedDBInstanceId", StringConversion.fromString((String)describeReservedDbInstancesRequest.reservedDBInstanceId()));
        }
        if (describeReservedDbInstancesRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringConversion.fromString((String)describeReservedDbInstancesRequest.reservedDBInstancesOfferingId()));
        }
        if (describeReservedDbInstancesRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)describeReservedDbInstancesRequest.dbInstanceClass()));
        }
        if (describeReservedDbInstancesRequest.duration() != null) {
            request.addParameter("Duration", StringConversion.fromString((String)describeReservedDbInstancesRequest.duration()));
        }
        if (describeReservedDbInstancesRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringConversion.fromString((String)describeReservedDbInstancesRequest.productDescription()));
        }
        if (describeReservedDbInstancesRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringConversion.fromString((String)describeReservedDbInstancesRequest.offeringType()));
        }
        if (describeReservedDbInstancesRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)describeReservedDbInstancesRequest.multiAZ()));
        }
        if (describeReservedDbInstancesRequest.filters().isEmpty() && !(describeReservedDbInstancesRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeReservedDbInstancesRequest.filters().isEmpty() && !(describeReservedDbInstancesRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeReservedDbInstancesRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedDbInstancesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeReservedDbInstancesRequest.maxRecords()));
        }
        if (describeReservedDbInstancesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeReservedDbInstancesRequest.marker()));
        }
        return request;
    }
}

