/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeOptionGroupOptionsRequestMarshaller
implements Marshaller<Request<DescribeOptionGroupOptionsRequest>, DescribeOptionGroupOptionsRequest> {
    public Request<DescribeOptionGroupOptionsRequest> marshall(DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) {
        if (describeOptionGroupOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeOptionGroupOptionsRequest, "RdsClient");
        request.addParameter("Action", "DescribeOptionGroupOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOptionGroupOptionsRequest.engineName() != null) {
            request.addParameter("EngineName", StringConversion.fromString((String)describeOptionGroupOptionsRequest.engineName()));
        }
        if (describeOptionGroupOptionsRequest.majorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringConversion.fromString((String)describeOptionGroupOptionsRequest.majorEngineVersion()));
        }
        if (describeOptionGroupOptionsRequest.filters().isEmpty() && !(describeOptionGroupOptionsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeOptionGroupOptionsRequest.filters().isEmpty() && !(describeOptionGroupOptionsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeOptionGroupOptionsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOptionGroupOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeOptionGroupOptionsRequest.maxRecords()));
        }
        if (describeOptionGroupOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeOptionGroupOptionsRequest.marker()));
        }
        return request;
    }
}

