/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEventsRequest, "RdsClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.sourceIdentifier() != null) {
            request.addParameter("SourceIdentifier", StringConversion.fromString((String)describeEventsRequest.sourceIdentifier()));
        }
        if (describeEventsRequest.sourceTypeAsString() != null) {
            request.addParameter("SourceType", StringConversion.fromString((String)describeEventsRequest.sourceTypeAsString()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.duration() != null) {
            request.addParameter("Duration", StringConversion.fromInteger((Integer)describeEventsRequest.duration()));
        }
        if (describeEventsRequest.eventCategories().isEmpty() && !(describeEventsRequest.eventCategories() instanceof SdkAutoConstructList)) {
            request.addParameter("EventCategories", "");
        } else if (!describeEventsRequest.eventCategories().isEmpty() && !(describeEventsRequest.eventCategories() instanceof SdkAutoConstructList)) {
            List<String> eventCategoriesList = describeEventsRequest.eventCategories();
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringConversion.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (describeEventsRequest.filters().isEmpty() && !(describeEventsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeEventsRequest.filters().isEmpty() && !(describeEventsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeEventsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeEventsRequest.marker()));
        }
        return request;
    }
}

