/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbParameterGroupsRequestMarshaller
implements Marshaller<Request<DescribeDbParameterGroupsRequest>, DescribeDbParameterGroupsRequest> {
    public Request<DescribeDbParameterGroupsRequest> marshall(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        if (describeDbParameterGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbParameterGroupsRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBParameterGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbParameterGroupsRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringConversion.fromString((String)describeDbParameterGroupsRequest.dbParameterGroupName()));
        }
        if (describeDbParameterGroupsRequest.filters().isEmpty() && !(describeDbParameterGroupsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbParameterGroupsRequest.filters().isEmpty() && !(describeDbParameterGroupsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbParameterGroupsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbParameterGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbParameterGroupsRequest.maxRecords()));
        }
        if (describeDbParameterGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbParameterGroupsRequest.marker()));
        }
        return request;
    }
}

