/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest;

public class DeleteDbInstanceRequestMarshaller
implements Marshaller<Request<DeleteDbInstanceRequest>, DeleteDbInstanceRequest> {
    public Request<DeleteDbInstanceRequest> marshall(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        if (deleteDbInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDbInstanceRequest, "RdsClient");
        request.addParameter("Action", "DeleteDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDbInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)deleteDbInstanceRequest.dbInstanceIdentifier()));
        }
        if (deleteDbInstanceRequest.skipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringConversion.fromBoolean((Boolean)deleteDbInstanceRequest.skipFinalSnapshot()));
        }
        if (deleteDbInstanceRequest.finalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringConversion.fromString((String)deleteDbInstanceRequest.finalDBSnapshotIdentifier()));
        }
        return request;
    }
}

