/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest;

public class DeleteDbClusterRequestMarshaller
implements Marshaller<Request<DeleteDbClusterRequest>, DeleteDbClusterRequest> {
    public Request<DeleteDbClusterRequest> marshall(DeleteDbClusterRequest deleteDbClusterRequest) {
        if (deleteDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDbClusterRequest, "RdsClient");
        request.addParameter("Action", "DeleteDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)deleteDbClusterRequest.dbClusterIdentifier()));
        }
        if (deleteDbClusterRequest.skipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringConversion.fromBoolean((Boolean)deleteDbClusterRequest.skipFinalSnapshot()));
        }
        if (deleteDbClusterRequest.finalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringConversion.fromString((String)deleteDbClusterRequest.finalDBSnapshotIdentifier()));
        }
        return request;
    }
}

