/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbSnapshotRequestMarshaller
implements Marshaller<Request<CreateDbSnapshotRequest>, CreateDbSnapshotRequest> {
    public Request<CreateDbSnapshotRequest> marshall(CreateDbSnapshotRequest createDbSnapshotRequest) {
        if (createDbSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbSnapshotRequest, "RdsClient");
        request.addParameter("Action", "CreateDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)createDbSnapshotRequest.dbSnapshotIdentifier()));
        }
        if (createDbSnapshotRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)createDbSnapshotRequest.dbInstanceIdentifier()));
        }
        if (createDbSnapshotRequest.tags().isEmpty() && !(createDbSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbSnapshotRequest.tags().isEmpty() && !(createDbSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

