/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbSecurityGroupRequestMarshaller
implements Marshaller<Request<CreateDbSecurityGroupRequest>, CreateDbSecurityGroupRequest> {
    public Request<CreateDbSecurityGroupRequest> marshall(CreateDbSecurityGroupRequest createDbSecurityGroupRequest) {
        if (createDbSecurityGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbSecurityGroupRequest, "RdsClient");
        request.addParameter("Action", "CreateDBSecurityGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbSecurityGroupRequest.dbSecurityGroupName() != null) {
            request.addParameter("DBSecurityGroupName", StringConversion.fromString((String)createDbSecurityGroupRequest.dbSecurityGroupName()));
        }
        if (createDbSecurityGroupRequest.dbSecurityGroupDescription() != null) {
            request.addParameter("DBSecurityGroupDescription", StringConversion.fromString((String)createDbSecurityGroupRequest.dbSecurityGroupDescription()));
        }
        if (createDbSecurityGroupRequest.tags().isEmpty() && !(createDbSecurityGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbSecurityGroupRequest.tags().isEmpty() && !(createDbSecurityGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbSecurityGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

