/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;

public class DescribeReservedDBInstancesIterable
implements SdkIterable<DescribeReservedDbInstancesResponse> {
    private final RdsClient client;
    private final DescribeReservedDbInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesIterable(RdsClient client, DescribeReservedDbInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedDbInstancesResponseFetcher();
    }

    public Iterator<DescribeReservedDbInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedDBInstance> reservedDBInstances() {
        Function<DescribeReservedDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstances() != null) {
                return response.reservedDBInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeReservedDBInstancesIterable resume(DescribeReservedDbInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedDBInstancesIterable(this.client, (DescribeReservedDbInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedDBInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedDbInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedDbInstancesResponseFetcher
    implements SyncPageFetcher<DescribeReservedDbInstancesResponse> {
        private DescribeReservedDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDbInstancesResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeReservedDbInstancesResponse nextPage(DescribeReservedDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesIterable.this.client.describeReservedDBInstances(DescribeReservedDBInstancesIterable.this.firstRequest);
            }
            return DescribeReservedDBInstancesIterable.this.client.describeReservedDBInstances((DescribeReservedDbInstancesRequest)((Object)DescribeReservedDBInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

