/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.Event;

public class DescribeEventsIterable
implements SdkIterable<DescribeEventsResponse> {
    private final RdsClient client;
    private final DescribeEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventsIterable(RdsClient client, DescribeEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public Iterator<DescribeEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Event> events() {
        Function<DescribeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeEventsIterable resume(DescribeEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventsIterable(this.client, (DescribeEventsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEventsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEventsResponseFetcher
    implements SyncPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeEventsResponse nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsIterable.this.client.describeEvents(DescribeEventsIterable.this.firstRequest);
            }
            return DescribeEventsIterable.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

