/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;

public class DescribeDBSnapshotsPublisher
implements SdkPublisher<DescribeDbSnapshotsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSnapshotsPublisher(RdsAsyncClient client, DescribeDbSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSnapshotsPublisher(RdsAsyncClient client, DescribeDbSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBSnapshot> dbSnapshots() {
        Function<DescribeDbSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSnapshots() != null) {
                return response.dbSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeDBSnapshotsPublisher resume(DescribeDbSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSnapshotsPublisher(this.client, (DescribeDbSnapshotsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSnapshotsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDbSnapshotsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDbSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeDbSnapshotsResponse> {
        private DescribeDbSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSnapshotsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<DescribeDbSnapshotsResponse> nextPage(DescribeDbSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotsPublisher.this.client.describeDBSnapshots(DescribeDBSnapshotsPublisher.this.firstRequest);
            }
            return DescribeDBSnapshotsPublisher.this.client.describeDBSnapshots((DescribeDbSnapshotsRequest)((Object)DescribeDBSnapshotsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

