/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeDbSecurityGroupIngressRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, RevokeDbSecurityGroupIngressRequest> {
    private final String dbSecurityGroupName;
    private final String cidrip;
    private final String ec2SecurityGroupName;
    private final String ec2SecurityGroupId;
    private final String ec2SecurityGroupOwnerId;

    private RevokeDbSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.cidrip = builder.cidrip;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupId = builder.ec2SecurityGroupId;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    public String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public String cidrip() {
        return this.cidrip;
    }

    public String ec2SecurityGroupName() {
        return this.ec2SecurityGroupName;
    }

    public String ec2SecurityGroupId() {
        return this.ec2SecurityGroupId;
    }

    public String ec2SecurityGroupOwnerId() {
        return this.ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrip());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupOwnerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeDbSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeDbSecurityGroupIngressRequest other = (RevokeDbSecurityGroupIngressRequest)((Object)obj);
        return Objects.equals(this.dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(this.cidrip(), other.cidrip()) && Objects.equals(this.ec2SecurityGroupName(), other.ec2SecurityGroupName()) && Objects.equals(this.ec2SecurityGroupId(), other.ec2SecurityGroupId()) && Objects.equals(this.ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    public String toString() {
        return ToString.builder((String)"RevokeDbSecurityGroupIngressRequest").add("DBSecurityGroupName", (Object)this.dbSecurityGroupName()).add("CIDRIP", (Object)this.cidrip()).add("EC2SecurityGroupName", (Object)this.ec2SecurityGroupName()).add("EC2SecurityGroupId", (Object)this.ec2SecurityGroupId()).add("EC2SecurityGroupOwnerId", (Object)this.ec2SecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupName()));
            }
            case "CIDRIP": {
                return Optional.ofNullable(clazz.cast(this.cidrip()));
            }
            case "EC2SecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupName()));
            }
            case "EC2SecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupId()));
            }
            case "EC2SecurityGroupOwnerId": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbSecurityGroupName;
        private String cidrip;
        private String ec2SecurityGroupName;
        private String ec2SecurityGroupId;
        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeDbSecurityGroupIngressRequest model) {
            super(model);
            this.dbSecurityGroupName(model.dbSecurityGroupName);
            this.cidrip(model.cidrip);
            this.ec2SecurityGroupName(model.ec2SecurityGroupName);
            this.ec2SecurityGroupId(model.ec2SecurityGroupId);
            this.ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getDBSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDBSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final String getCIDRIP() {
            return this.cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCIDRIP(String cidrip) {
            this.cidrip = cidrip;
        }

        public final String getEC2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEC2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEC2SecurityGroupId() {
            return this.ec2SecurityGroupId;
        }

        @Override
        public final Builder ec2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
            return this;
        }

        public final void setEC2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
        }

        public final String getEC2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEC2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeDbSecurityGroupIngressRequest build() {
            return new RevokeDbSecurityGroupIngressRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, RevokeDbSecurityGroupIngressRequest> {
        public Builder dbSecurityGroupName(String var1);

        public Builder cidrip(String var1);

        public Builder ec2SecurityGroupName(String var1);

        public Builder ec2SecurityGroupId(String var1);

        public Builder ec2SecurityGroupOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

