/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupNameListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbInstanceFromS3Request
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbInstanceFromS3Request> {
    private final String dbName;
    private final String dbInstanceIdentifier;
    private final Integer allocatedStorage;
    private final String dbInstanceClass;
    private final String engine;
    private final String masterUsername;
    private final String masterUserPassword;
    private final List<String> dbSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String availabilityZone;
    private final String dbSubnetGroupName;
    private final String preferredMaintenanceWindow;
    private final String dbParameterGroupName;
    private final Integer backupRetentionPeriod;
    private final String preferredBackupWindow;
    private final Integer port;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final String licenseModel;
    private final Integer iops;
    private final String optionGroupName;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;
    private final String storageType;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final Boolean enableIAMDatabaseAuthentication;
    private final String sourceEngine;
    private final String sourceEngineVersion;
    private final String s3BucketName;
    private final String s3Prefix;
    private final String s3IngestionRoleArn;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;

    private RestoreDbInstanceFromS3Request(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.storageType = builder.storageType;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.sourceEngine = builder.sourceEngine;
        this.sourceEngineVersion = builder.sourceEngineVersion;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3IngestionRoleArn = builder.s3IngestionRoleArn;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
    }

    public String dbName() {
        return this.dbName;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String engine() {
        return this.engine;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public List<String> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Integer port() {
        return this.port;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String storageType() {
        return this.storageType;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public String sourceEngine() {
        return this.sourceEngine;
    }

    public String sourceEngineVersion() {
        return this.sourceEngineVersion;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3Prefix() {
        return this.s3Prefix;
    }

    public String s3IngestionRoleArn() {
        return this.s3IngestionRoleArn;
    }

    public Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3IngestionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbInstanceFromS3Request)) {
            return false;
        }
        RestoreDbInstanceFromS3Request other = (RestoreDbInstanceFromS3Request)((Object)obj);
        return Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.dbSecurityGroups(), other.dbSecurityGroups()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.sourceEngine(), other.sourceEngine()) && Objects.equals(this.sourceEngineVersion(), other.sourceEngineVersion()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3IngestionRoleArn(), other.s3IngestionRoleArn()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId());
    }

    public String toString() {
        return ToString.builder((String)"RestoreDbInstanceFromS3Request").add("DBName", (Object)this.dbName()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Engine", (Object)this.engine()).add("MasterUsername", (Object)this.masterUsername()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("DBSecurityGroups", this.dbSecurityGroups()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("AvailabilityZone", (Object)this.availabilityZone()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("Port", (Object)this.port()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("LicenseModel", (Object)this.licenseModel()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Tags", this.tags()).add("StorageType", (Object)this.storageType()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("SourceEngine", (Object)this.sourceEngine()).add("SourceEngineVersion", (Object)this.sourceEngineVersion()).add("S3BucketName", (Object)this.s3BucketName()).add("S3Prefix", (Object)this.s3Prefix()).add("S3IngestionRoleArn", (Object)this.s3IngestionRoleArn()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "DBSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "DBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupName()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "SourceEngine": {
                return Optional.ofNullable(clazz.cast(this.sourceEngine()));
            }
            case "SourceEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceEngineVersion()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3IngestionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.s3IngestionRoleArn()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbName;
        private String dbInstanceIdentifier;
        private Integer allocatedStorage;
        private String dbInstanceClass;
        private String engine;
        private String masterUsername;
        private String masterUserPassword;
        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String dbSubnetGroupName;
        private String preferredMaintenanceWindow;
        private String dbParameterGroupName;
        private Integer backupRetentionPeriod;
        private String preferredBackupWindow;
        private Integer port;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private String licenseModel;
        private Integer iops;
        private String optionGroupName;
        private Boolean publiclyAccessible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private Boolean enableIAMDatabaseAuthentication;
        private String sourceEngine;
        private String sourceEngineVersion;
        private String s3BucketName;
        private String s3Prefix;
        private String s3IngestionRoleArn;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbInstanceFromS3Request model) {
            super(model);
            this.dbName(model.dbName);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.allocatedStorage(model.allocatedStorage);
            this.dbInstanceClass(model.dbInstanceClass);
            this.engine(model.engine);
            this.masterUsername(model.masterUsername);
            this.masterUserPassword(model.masterUserPassword);
            this.dbSecurityGroups(model.dbSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.availabilityZone(model.availabilityZone);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.port(model.port);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.licenseModel(model.licenseModel);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.tags(model.tags);
            this.storageType(model.storageType);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.sourceEngine(model.sourceEngine);
            this.sourceEngineVersion(model.sourceEngineVersion);
            this.s3BucketName(model.s3BucketName);
            this.s3Prefix(model.s3Prefix);
            this.s3IngestionRoleArn(model.s3IngestionRoleArn);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final Collection<String> getDBSecurityGroups() {
            return this.dbSecurityGroups;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final void setDBSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final String getSourceEngine() {
            return this.sourceEngine;
        }

        @Override
        public final Builder sourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
            return this;
        }

        public final void setSourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
        }

        public final String getSourceEngineVersion() {
            return this.sourceEngineVersion;
        }

        @Override
        public final Builder sourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
            return this;
        }

        public final void setSourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3IngestionRoleArn() {
            return this.s3IngestionRoleArn;
        }

        @Override
        public final Builder s3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
            return this;
        }

        public final void setS3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbInstanceFromS3Request build() {
            return new RestoreDbInstanceFromS3Request(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, RestoreDbInstanceFromS3Request> {
        public Builder dbName(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder dbInstanceClass(String var1);

        public Builder engine(String var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder dbSecurityGroups(Collection<String> var1);

        public Builder dbSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder dbParameterGroupName(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder preferredBackupWindow(String var1);

        public Builder port(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageType(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder sourceEngine(String var1);

        public Builder sourceEngineVersion(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3IngestionRoleArn(String var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

