/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingModifiedValues
implements ToCopyableBuilder<Builder, PendingModifiedValues> {
    private final String dbInstanceClass;
    private final Integer allocatedStorage;
    private final String masterUserPassword;
    private final Integer port;
    private final Integer backupRetentionPeriod;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final String licenseModel;
    private final Integer iops;
    private final String dbInstanceIdentifier;
    private final String storageType;
    private final String caCertificateIdentifier;
    private final String dbSubnetGroupName;

    private PendingModifiedValues(BuilderImpl builder) {
        this.dbInstanceClass = builder.dbInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.masterUserPassword = builder.masterUserPassword;
        this.port = builder.port;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.storageType = builder.storageType;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public Integer port() {
        return this.port;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Integer iops() {
        return this.iops;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String storageType() {
        return this.storageType;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues)obj;
        return Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName());
    }

    public String toString() {
        return ToString.builder((String)"PendingModifiedValues").add("DBInstanceClass", (Object)this.dbInstanceClass()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("Port", (Object)this.port()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("LicenseModel", (Object)this.licenseModel()).add("Iops", (Object)this.iops()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("StorageType", (Object)this.storageType()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceClass;
        private Integer allocatedStorage;
        private String masterUserPassword;
        private Integer port;
        private Integer backupRetentionPeriod;
        private Boolean multiAZ;
        private String engineVersion;
        private String licenseModel;
        private Integer iops;
        private String dbInstanceIdentifier;
        private String storageType;
        private String caCertificateIdentifier;
        private String dbSubnetGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            this.dbInstanceClass(model.dbInstanceClass);
            this.allocatedStorage(model.allocatedStorage);
            this.masterUserPassword(model.masterUserPassword);
            this.port(model.port);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.iops(model.iops);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.storageType(model.storageType);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getCACertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCACertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingModifiedValues> {
        public Builder dbInstanceClass(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder masterUserPassword(String var1);

        public Builder port(Integer var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder storageType(String var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder dbSubnetGroupName(String var1);
    }
}

