/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeValidDbInstanceModificationsRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DescribeValidDbInstanceModificationsRequest> {
    private final String dbInstanceIdentifier;

    private DescribeValidDbInstanceModificationsRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeValidDbInstanceModificationsRequest)) {
            return false;
        }
        DescribeValidDbInstanceModificationsRequest other = (DescribeValidDbInstanceModificationsRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"DescribeValidDbInstanceModificationsRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeValidDbInstanceModificationsRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeValidDbInstanceModificationsRequest build() {
            return new DescribeValidDbInstanceModificationsRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, DescribeValidDbInstanceModificationsRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

