/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;
import software.amazon.awssdk.services.rds.model.ReservedDBInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedDbInstancesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeReservedDbInstancesResponse> {
    private final String marker;
    private final List<ReservedDBInstance> reservedDBInstances;

    private DescribeReservedDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedDBInstances = builder.reservedDBInstances;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedDBInstance> reservedDBInstances() {
        return this.reservedDBInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesResponse)) {
            return false;
        }
        DescribeReservedDbInstancesResponse other = (DescribeReservedDbInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedDBInstances(), other.reservedDBInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedDbInstancesResponse").add("Marker", (Object)this.marker()).add("ReservedDBInstances", this.reservedDBInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedDBInstances": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedDBInstance> reservedDBInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedDBInstances(model.reservedDBInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstance.Builder> getReservedDBInstances() {
            return this.reservedDBInstances != null ? (Collection)this.reservedDBInstances.stream().map(ReservedDBInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedDBInstances(Collection<ReservedDBInstance> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copy(reservedDBInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(ReservedDBInstance ... reservedDBInstances) {
            this.reservedDBInstances(Arrays.asList(reservedDBInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(Consumer<ReservedDBInstance.Builder> ... reservedDBInstances) {
            this.reservedDBInstances(Stream.of(reservedDBInstances).map(c -> (ReservedDBInstance)((ReservedDBInstance.Builder)ReservedDBInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedDBInstances(Collection<ReservedDBInstance.BuilderImpl> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copyFromBuilder(reservedDBInstances);
        }

        @Override
        public DescribeReservedDbInstancesResponse build() {
            return new DescribeReservedDbInstancesResponse(this);
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    CopyableBuilder<Builder, DescribeReservedDbInstancesResponse> {
        public Builder marker(String var1);

        public Builder reservedDBInstances(Collection<ReservedDBInstance> var1);

        public Builder reservedDBInstances(ReservedDBInstance ... var1);

        public Builder reservedDBInstances(Consumer<ReservedDBInstance.Builder> ... var1);
    }
}

