/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbLogFilesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbLogFilesResponse> {
    private final List<DescribeDBLogFilesDetails> describeDBLogFiles;
    private final String marker;

    private DescribeDbLogFilesResponse(BuilderImpl builder) {
        super(builder);
        this.describeDBLogFiles = builder.describeDBLogFiles;
        this.marker = builder.marker;
    }

    public List<DescribeDBLogFilesDetails> describeDBLogFiles() {
        return this.describeDBLogFiles;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.describeDBLogFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbLogFilesResponse)) {
            return false;
        }
        DescribeDbLogFilesResponse other = (DescribeDbLogFilesResponse)((Object)obj);
        return Objects.equals(this.describeDBLogFiles(), other.describeDBLogFiles()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbLogFilesResponse").add("DescribeDBLogFiles", this.describeDBLogFiles()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DescribeDBLogFiles": {
                return Optional.ofNullable(clazz.cast(this.describeDBLogFiles()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DescribeDBLogFilesDetails> describeDBLogFiles = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbLogFilesResponse model) {
            super(model);
            this.describeDBLogFiles(model.describeDBLogFiles);
            this.marker(model.marker);
        }

        public final Collection<DescribeDBLogFilesDetails.Builder> getDescribeDBLogFiles() {
            return this.describeDBLogFiles != null ? (Collection)this.describeDBLogFiles.stream().map(DescribeDBLogFilesDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder describeDBLogFiles(Collection<DescribeDBLogFilesDetails> describeDBLogFiles) {
            this.describeDBLogFiles = DescribeDBLogFilesListCopier.copy(describeDBLogFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder describeDBLogFiles(DescribeDBLogFilesDetails ... describeDBLogFiles) {
            this.describeDBLogFiles(Arrays.asList(describeDBLogFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder describeDBLogFiles(Consumer<DescribeDBLogFilesDetails.Builder> ... describeDBLogFiles) {
            this.describeDBLogFiles(Stream.of(describeDBLogFiles).map(c -> (DescribeDBLogFilesDetails)((DescribeDBLogFilesDetails.Builder)DescribeDBLogFilesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDescribeDBLogFiles(Collection<DescribeDBLogFilesDetails.BuilderImpl> describeDBLogFiles) {
            this.describeDBLogFiles = DescribeDBLogFilesListCopier.copyFromBuilder(describeDBLogFiles);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeDbLogFilesResponse build() {
            return new DescribeDbLogFilesResponse(this);
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    CopyableBuilder<Builder, DescribeDbLogFilesResponse> {
        public Builder describeDBLogFiles(Collection<DescribeDBLogFilesDetails> var1);

        public Builder describeDBLogFiles(DescribeDBLogFilesDetails ... var1);

        public Builder describeDBLogFiles(Consumer<DescribeDBLogFilesDetails.Builder> ... var1);

        public Builder marker(String var1);
    }
}

