/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbSnapshotRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbSnapshotRequest> {
    private final String dbSnapshotIdentifier;
    private final String dbInstanceIdentifier;
    private final List<Tag> tags;

    private CreateDbSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tags = builder.tags;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbSnapshotRequest)) {
            return false;
        }
        CreateDbSnapshotRequest other = (CreateDbSnapshotRequest)((Object)obj);
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDbSnapshotRequest").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String dbInstanceIdentifier;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbSnapshotRequest model) {
            super(model);
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.tags(model.tags);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbSnapshotRequest build() {
            return new CreateDbSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, CreateDbSnapshotRequest> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

