/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.net.URI;
import java.time.Clock;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.internal.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

abstract class RdsPresignInterceptor<T extends RdsRequest>
implements ExecutionInterceptor {
    private static final String SERVICE_NAME = "rds";
    private static final String PARAM_SOURCE_REGION = "SourceRegion";
    private static final String PARAM_DESTINATION_REGION = "DestinationRegion";
    private static final String PARAM_PRESIGNED_URL = "PreSignedUrl";
    private final Class<T> requestClassToPreSign;
    private final Clock signingOverrideClock;

    RdsPresignInterceptor(Class<T> requestClassToPreSign) {
        this(requestClassToPreSign, null);
    }

    RdsPresignInterceptor(Class<T> requestClassToPreSign, Clock signingOverrideClock) {
        this.requestClassToPreSign = requestClassToPreSign;
        this.signingOverrideClock = signingOverrideClock;
    }

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (!this.requestClassToPreSign.isInstance(originalRequest)) {
            return request;
        }
        if (request.rawQueryParameters().containsKey(PARAM_PRESIGNED_URL)) {
            return request;
        }
        PresignableRequest presignableRequest = this.adaptRequest((RdsRequest)((Object)this.requestClassToPreSign.cast(originalRequest)));
        String sourceRegion = presignableRequest.getSourceRegion();
        if (sourceRegion == null) {
            return request;
        }
        String destinationRegion = ((Region)AwsHostNameUtils.parseSigningRegion((String)request.host(), (String)SERVICE_NAME).orElseThrow(() -> new IllegalArgumentException("Could not determine region for " + request.host()))).id();
        URI endpoint = this.createEndpoint(sourceRegion, SERVICE_NAME);
        Request<?> legacyRequest = presignableRequest.marshall();
        legacyRequest.setEndpoint(endpoint);
        SdkHttpFullRequest.Builder marshalledRequest = SdkHttpFullRequestAdapter.toMutableHttpFullRequest(legacyRequest);
        SdkHttpFullRequest requestToPresign = (SdkHttpFullRequest)marshalledRequest.encodedPath(SdkHttpUtils.appendUri((String)endpoint.getPath(), (String)marshalledRequest.encodedPath())).method(SdkHttpMethod.GET).putRawQueryParameter(PARAM_DESTINATION_REGION, destinationRegion).removeQueryParameter(PARAM_SOURCE_REGION).build();
        requestToPresign = this.presignRequest(requestToPresign, executionAttributes, sourceRegion);
        String presignedUrl = requestToPresign.getUri().toString();
        return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).putRawQueryParameter(PARAM_PRESIGNED_URL, presignedUrl).removeQueryParameter(PARAM_SOURCE_REGION).build();
    }

    protected abstract PresignableRequest adaptRequest(T var1);

    private SdkHttpFullRequest presignRequest(SdkHttpFullRequest request, ExecutionAttributes attributes, String signingRegion) {
        Aws4Signer signer = Aws4Signer.create();
        Aws4PresignerParams presignerParams = ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingRegion(Region.of((String)signingRegion))).signingName(SERVICE_NAME)).signingClockOverride(this.signingOverrideClock)).awsCredentials((AwsCredentials)attributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS))).build();
        return signer.presign(request, presignerParams);
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw SdkClientException.builder().message("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.").build();
        }
        return new DefaultServiceEndpointBuilder(SERVICE_NAME, Protocol.HTTPS.toString()).withRegion(region).getServiceEndpoint();
    }

    protected static interface PresignableRequest {
        public String getSourceRegion();

        public Request<?> marshall();
    }
}

