/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.transform.CharacterSetUnmarshaller;
import software.amazon.awssdk.services.rds.transform.TimezoneUnmarshaller;
import software.amazon.awssdk.services.rds.transform.UpgradeTargetUnmarshaller;

public class DBEngineVersionUnmarshaller
implements Unmarshaller<DBEngineVersion, StaxUnmarshallerContext> {
    private static final DBEngineVersionUnmarshaller INSTANCE = new DBEngineVersionUnmarshaller();

    public DBEngineVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBEngineVersion.Builder dbEngineVersion;
        block15: {
            dbEngineVersion = DBEngineVersion.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CharacterSet> supportedCharacterSets = null;
            ArrayList<UpgradeTarget> validUpgradeTarget = null;
            ArrayList<Timezone> supportedTimezones = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    dbEngineVersion.supportedCharacterSets(supportedCharacterSets);
                    dbEngineVersion.validUpgradeTarget(validUpgradeTarget);
                    dbEngineVersion.supportedTimezones(supportedTimezones);
                    break block15;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Engine", targetDepth)) {
                        dbEngineVersion.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EngineVersion", targetDepth)) {
                        dbEngineVersion.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                        dbEngineVersion.dbParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBEngineDescription", targetDepth)) {
                        dbEngineVersion.dbEngineDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBEngineVersionDescription", targetDepth)) {
                        dbEngineVersion.dbEngineVersionDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DefaultCharacterSet", targetDepth)) {
                        dbEngineVersion.defaultCharacterSet(CharacterSetUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportedCharacterSets", targetDepth)) {
                        supportedCharacterSets = new ArrayList<CharacterSet>();
                        continue;
                    }
                    if (context.testExpression("SupportedCharacterSets/CharacterSet", targetDepth)) {
                        supportedCharacterSets.add(CharacterSetUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ValidUpgradeTarget", targetDepth)) {
                        validUpgradeTarget = new ArrayList<UpgradeTarget>();
                        continue;
                    }
                    if (context.testExpression("ValidUpgradeTarget/UpgradeTarget", targetDepth)) {
                        validUpgradeTarget.add(UpgradeTargetUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportedTimezones", targetDepth)) {
                        supportedTimezones = new ArrayList<Timezone>();
                        continue;
                    }
                    if (!context.testExpression("SupportedTimezones/Timezone", targetDepth)) continue;
                    supportedTimezones.add(TimezoneUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            dbEngineVersion.supportedCharacterSets(supportedCharacterSets);
            dbEngineVersion.validUpgradeTarget(validUpgradeTarget);
            dbEngineVersion.supportedTimezones(supportedTimezones);
        }
        return (DBEngineVersion)dbEngineVersion.build();
    }

    public static DBEngineVersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

