/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsResponse;

public class DescribeDBSnapshotsPublisher
implements SdkPublisher<DescribeDBSnapshotsResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSnapshotsPublisher(RDSAsyncClient client, DescribeDBSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSnapshotsPublisher(RDSAsyncClient client, DescribeDBSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DBSnapshot> dbSnapshots() {
        Function<DescribeDBSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSnapshots() != null) {
                return response.dbSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBSnapshotsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBSnapshotsPublisher resume(DescribeDBSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSnapshotsPublisher(this.client, (DescribeDBSnapshotsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSnapshotsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBSnapshotsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeDBSnapshotsResponse> {
        private DescribeDBSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSnapshotsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBSnapshotsResponse> nextPage(DescribeDBSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotsPublisher.this.client.describeDBSnapshots(DescribeDBSnapshotsPublisher.this.firstRequest);
            }
            return DescribeDBSnapshotsPublisher.this.client.describeDBSnapshots((DescribeDBSnapshotsRequest)((Object)DescribeDBSnapshotsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

