/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSecurityGroupsResponse;

public class DescribeDBSecurityGroupsPublisher
implements SdkPublisher<DescribeDBSecurityGroupsResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSecurityGroupsPublisher(RDSAsyncClient client, DescribeDBSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSecurityGroupsPublisher(RDSAsyncClient client, DescribeDBSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DBSecurityGroup> dbSecurityGroups() {
        Function<DescribeDBSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSecurityGroups() != null) {
                return response.dbSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBSecurityGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBSecurityGroupsPublisher resume(DescribeDBSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSecurityGroupsPublisher(this.client, (DescribeDBSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSecurityGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBSecurityGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDBSecurityGroupsResponse> {
        private DescribeDBSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBSecurityGroupsResponse> nextPage(DescribeDBSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSecurityGroupsPublisher.this.client.describeDBSecurityGroups(DescribeDBSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeDBSecurityGroupsPublisher.this.client.describeDBSecurityGroups((DescribeDBSecurityGroupsRequest)((Object)DescribeDBSecurityGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

