/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersResponse;
import software.amazon.awssdk.services.rds.model.Parameter;

public class DescribeDBParametersPublisher
implements SdkPublisher<DescribeDBParametersResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBParametersPublisher(RDSAsyncClient client, DescribeDBParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBParametersPublisher(RDSAsyncClient client, DescribeDBParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeDBParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBParametersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBParametersPublisher resume(DescribeDBParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBParametersPublisher(this.client, (DescribeDBParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBParametersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBParametersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBParametersResponseFetcher
    implements AsyncPageFetcher<DescribeDBParametersResponse> {
        private DescribeDBParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBParametersResponse> nextPage(DescribeDBParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParametersPublisher.this.client.describeDBParameters(DescribeDBParametersPublisher.this.firstRequest);
            }
            return DescribeDBParametersPublisher.this.client.describeDBParameters((DescribeDBParametersRequest)((Object)DescribeDBParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

