/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBParameterGroupsResponse;

public class DescribeDBParameterGroupsPublisher
implements SdkPublisher<DescribeDBParameterGroupsResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBParameterGroupsPublisher(RDSAsyncClient client, DescribeDBParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBParameterGroupsPublisher(RDSAsyncClient client, DescribeDBParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DBParameterGroup> dbParameterGroups() {
        Function<DescribeDBParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbParameterGroups() != null) {
                return response.dbParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBParameterGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBParameterGroupsPublisher resume(DescribeDBParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBParameterGroupsPublisher(this.client, (DescribeDBParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBParameterGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBParameterGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBParameterGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDBParameterGroupsResponse> {
        private DescribeDBParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBParameterGroupsResponse> nextPage(DescribeDBParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParameterGroupsPublisher.this.client.describeDBParameterGroups(DescribeDBParameterGroupsPublisher.this.firstRequest);
            }
            return DescribeDBParameterGroupsPublisher.this.client.describeDBParameterGroups((DescribeDBParameterGroupsRequest)((Object)DescribeDBParameterGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

