/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesResponse;

public class DescribeDBInstancesPublisher
implements SdkPublisher<DescribeDBInstancesResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBInstancesPublisher(RDSAsyncClient client, DescribeDBInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBInstancesPublisher(RDSAsyncClient client, DescribeDBInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DBInstance> dbInstances() {
        Function<DescribeDBInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstances() != null) {
                return response.dbInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBInstancesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBInstancesPublisher resume(DescribeDBInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBInstancesPublisher(this.client, (DescribeDBInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeDBInstancesResponse> {
        private DescribeDBInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBInstancesResponse> nextPage(DescribeDBInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstancesPublisher.this.client.describeDBInstances(DescribeDBInstancesPublisher.this.firstRequest);
            }
            return DescribeDBInstancesPublisher.this.client.describeDBInstances((DescribeDBInstancesRequest)((Object)DescribeDBInstancesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

