/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsResponse;

public class DescribeDBEngineVersionsIterable
implements SdkIterable<DescribeDBEngineVersionsResponse> {
    private final RDSClient client;
    private final DescribeDBEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBEngineVersionsIterable(RDSClient client, DescribeDBEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeDBEngineVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DBEngineVersion> dbEngineVersions() {
        Function<DescribeDBEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbEngineVersions() != null) {
                return response.dbEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBEngineVersionsIterable resume(DescribeDBEngineVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBEngineVersionsIterable(this.client, (DescribeDBEngineVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBEngineVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBEngineVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeDBEngineVersionsResponse> {
        private DescribeDBEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBEngineVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBEngineVersionsResponse nextPage(DescribeDBEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBEngineVersionsIterable.this.client.describeDBEngineVersions(DescribeDBEngineVersionsIterable.this.firstRequest);
            }
            return DescribeDBEngineVersionsIterable.this.client.describeDBEngineVersions((DescribeDBEngineVersionsRequest)((Object)DescribeDBEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

