/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DBSubnetGroupsCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBSubnetGroupsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBSubnetGroupsResponse> {
    private final String marker;
    private final List<DBSubnetGroup> dbSubnetGroups;

    private DescribeDBSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSubnetGroups = builder.dbSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBSubnetGroup> dbSubnetGroups() {
        return this.dbSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSubnetGroupsResponse)) {
            return false;
        }
        DescribeDBSubnetGroupsResponse other = (DescribeDBSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbSubnetGroups(), other.dbSubnetGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("DBSubnetGroups", this.dbSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBSubnetGroups": {
                return Optional.of(clazz.cast(this.dbSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSubnetGroup> dbSubnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbSubnetGroups(model.dbSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSubnetGroup.Builder> getDBSubnetGroups() {
            return this.dbSubnetGroups != null ? (Collection)this.dbSubnetGroups.stream().map(DBSubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copy(dbSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(DBSubnetGroup ... dbSubnetGroups) {
            this.dbSubnetGroups(Arrays.asList(dbSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder> ... dbSubnetGroups) {
            this.dbSubnetGroups(Stream.of(dbSubnetGroups).map(c -> (DBSubnetGroup)((DBSubnetGroup.Builder)DBSubnetGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBSubnetGroups(Collection<DBSubnetGroup.BuilderImpl> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copyFromBuilder(dbSubnetGroups);
        }

        @Override
        public DescribeDBSubnetGroupsResponse build() {
            return new DescribeDBSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbSubnetGroups(Collection<DBSubnetGroup> var1);

        public Builder dbSubnetGroups(DBSubnetGroup ... var1);

        public Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder> ... var1);
    }
}

