/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DBParameterGroupListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBParameterGroupsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBParameterGroupsResponse> {
    private final String marker;
    private final List<DBParameterGroup> dbParameterGroups;

    private DescribeDBParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbParameterGroups = builder.dbParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBParameterGroup> dbParameterGroups() {
        return this.dbParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBParameterGroupsResponse)) {
            return false;
        }
        DescribeDBParameterGroupsResponse other = (DescribeDBParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbParameterGroups(), other.dbParameterGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBParameterGroupsResponse").add("Marker", (Object)this.marker()).add("DBParameterGroups", this.dbParameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBParameterGroups": {
                return Optional.of(clazz.cast(this.dbParameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBParameterGroup> dbParameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBParameterGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbParameterGroups(model.dbParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBParameterGroup.Builder> getDBParameterGroups() {
            return this.dbParameterGroups != null ? (Collection)this.dbParameterGroups.stream().map(DBParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroup ... dbParameterGroups) {
            this.dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<DBParameterGroup.Builder> ... dbParameterGroups) {
            this.dbParameterGroups(Stream.of(dbParameterGroups).map(c -> (DBParameterGroup)((DBParameterGroup.Builder)DBParameterGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBParameterGroups(Collection<DBParameterGroup.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copyFromBuilder(dbParameterGroups);
        }

        @Override
        public DescribeDBParameterGroupsResponse build() {
            return new DescribeDBParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbParameterGroups(Collection<DBParameterGroup> var1);

        public Builder dbParameterGroups(DBParameterGroup ... var1);

        public Builder dbParameterGroups(Consumer<DBParameterGroup.Builder> ... var1);
    }
}

