/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DBInstanceListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBInstancesResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBInstancesResponse> {
    private final String marker;
    private final List<DBInstance> dbInstances;

    private DescribeDBInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbInstances = builder.dbInstances;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBInstance> dbInstances() {
        return this.dbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBInstancesResponse)) {
            return false;
        }
        DescribeDBInstancesResponse other = (DescribeDBInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbInstances(), other.dbInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBInstancesResponse").add("Marker", (Object)this.marker()).add("DBInstances", this.dbInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBInstances": {
                return Optional.of(clazz.cast(this.dbInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBInstance> dbInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbInstances(model.dbInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBInstance.Builder> getDBInstances() {
            return this.dbInstances != null ? (Collection)this.dbInstances.stream().map(DBInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbInstances(Collection<DBInstance> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copy(dbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(DBInstance ... dbInstances) {
            this.dbInstances(Arrays.asList(dbInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(Consumer<DBInstance.Builder> ... dbInstances) {
            this.dbInstances(Stream.of(dbInstances).map(c -> (DBInstance)((DBInstance.Builder)DBInstance.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBInstances(Collection<DBInstance.BuilderImpl> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copyFromBuilder(dbInstances);
        }

        @Override
        public DescribeDBInstancesResponse build() {
            return new DescribeDBInstancesResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBInstancesResponse> {
        public Builder marker(String var1);

        public Builder dbInstances(Collection<DBInstance> var1);

        public Builder dbInstances(DBInstance ... var1);

        public Builder dbInstances(Consumer<DBInstance.Builder> ... var1);
    }
}

